/*
          
JJMASeries.mqh  
PriceSeries.mqh 
  (): MetaTrader\experts\include\
Heiken Ashi#.mq4
  (): MetaTrader\indicators\
*/
//+------------------------------------------------------------------+  
//|                                    JDMoving Avereges_Channel.mq4 | 
//|                 JMA code: Copyright  2005, Weld, Jurik Research | 
//|                                          http://weld.torguem.net | 
//|         JMoving Avereges: Copyright  2006,     Nikolay Kositsin | 
//|                              Khabarovsk,   farria@mail.redcom.ru | 
//+------------------------------------------------------------------+  
#property copyright "Copyright  2006, Nikolay Kositsin"
#property link "farria@mail.redcom.ru" 
//----     
#property indicator_chart_window 
//----   
#property indicator_buffers 3
//----  
#property indicator_color1 Red
#property indicator_color2 Lime
#property indicator_color3 Lime
//----   
#property indicator_style1 0
#property indicator_style2 4
#property indicator_style3 4
//----    --------------------------------------------------------------------------------------------------+
extern int       Channel_width = 100; //    
extern int           MA_period = 8; //     
extern int           MA_method = 0;  //  
extern int           Smooth    = 8; //   
extern int Smooth_Phase  = 100;//  ,    -100 ... +100,     ; 
extern int             Step = 6; // ,       (     )
extern int               Shift = 0;  // c     
extern int Input_Price_Customs = 0;  // ,      
//(0-CLOSE, 1-OPEN, 2-HIGH, 3-LOW, 4-MEDIAN, 5-TYPICAL, 6-WEIGHTED, 7-Heiken Ashi Close, 8-SIMPL, 9-TRENDFOLLOW, 10-0.5*TRENDFOLLOW,
//11-Heiken Ashi Low, 12-Heiken Ashi High,  13-Heiken Ashi Open, 14-Heiken Ashi Close.)
//---- -------------------------------------------------------------------------------------------------------------------------------+
//----  
double Series_buffer[];
double JMovingBuffer[];
double UpperBuffer[];
double LowerBuffer[];
//----      
double Half_Width,Norma;
//+------------------------------------------------------------------+  
//----+   JJMASeries 
//----+   JJMASeriesResize 
//----+   JJMASeriesAlert  
//----+   JMA_ErrDescr  
#include <JJMASeries.mqh> 
//+------------------------------------------------------------------+  
//----+   PriceSeries
//----+   PriceSeriesAlert 
#include <PriceSeries.mqh>
//+------------------------------------------------------------------+  
//| JMoving Avereges_Channel initialization function                 | 
//+------------------------------------------------------------------+  
int init() 
{  
//----    
SetIndexStyle (0,DRAW_LINE);
SetIndexStyle (1,DRAW_LINE);
SetIndexStyle (2,DRAW_LINE); 
//---- 4   s  
IndicatorBuffers(4);
SetIndexBuffer(0,JMovingBuffer);  
SetIndexBuffer(1,UpperBuffer); 
SetIndexBuffer(2,LowerBuffer); 
SetIndexBuffer(3,Series_buffer);
//----    
SetIndexShift (0, Shift);  
SetIndexShift (1, Shift);
SetIndexShift (2, Shift);
//----   ,      
SetIndexEmptyValue(0,0); 
SetIndexEmptyValue(1,0);
SetIndexEmptyValue(2,0);
//----         
string Moving;
switch(MA_method)
    {
       case  0: Moving= "JSMA";break;
       case  1: Moving= "JEMA";break;
       case  2: Moving="JSSMA";break;
       case  3: Moving="JLWMA";break;
       default: Moving="JSMA";
    }
SetIndexLabel (0, "JMoving Avereges "+Moving+" ("+MA_period+", Shift="+Shift+")");
IndicatorShortName ("J"+Moving+"_Channel(Channel_width="+Channel_width+", MA_period="+MA_period+", Shift="+Shift+")"); 
SetIndexLabel (1, "Upper"); 
SetIndexLabel (2, "Lower"); 
//----     
IndicatorDigits(Digits);
//----+       JJMASeries, nJMAnumber=1(   )
if (JJMASeriesResize(1)!=1)return(-1);
//----       
JJMASeriesAlert (0,"MA_period",MA_period);
JJMASeriesAlert (0,"Smooth",Smooth);
JJMASeriesAlert (1,"Smooth_Phase",Smooth_Phase);
PriceSeriesAlert(Input_Price_Customs);
if((MA_method<0)||(MA_method>3))
       {Alert(" MA_method    0  3"+ "    " 
                                                         +MA_method+ "   0");}
//----     MA_period
if(MA_period<1)MA_period=1; 
//----   ,       
int draw_begin=MA_period+30; 
SetIndexDrawBegin(0,draw_begin);
SetIndexDrawBegin(1,draw_begin);
SetIndexDrawBegin(2,draw_begin); 
//----    
Half_Width = Channel_width*Point/2;
//----  
Norma=Step*Point;
//----  
return(0); 
} 
//+------------------------------------------------------------------+  
//| JMoving Avereges_Channel iteration function                      | 
//+------------------------------------------------------------------+  
int start() 
{ 
//----       
if(Bars-1<=MA_period+30) return(0);
//----       
double Temp_Series,Resalt;
//----+        
int reset,MaxBar,bar,counted_bars=IndicatorCounted();
//----    
if (counted_bars<0)return(-1);
//----       
//(    counted_bars  JJMASeries   !!!)
if (counted_bars>0)counted_bars--;
//----     ,        
int limit=Bars-counted_bars-1; MaxBar=Bars-1-MA_period; 
//----+     
for(bar=limit;bar>=0;bar--)Series_buffer[bar]=PriceSeries(Input_Price_Customs,bar);
//----      
//----            
if (limit>=MaxBar)
  {
   for(bar=limit;bar>=MaxBar;bar--)
     {
      JMovingBuffer[bar]=0.0;
      UpperBuffer  [bar]=0.0; 
      LowerBuffer  [bar]=0.0;
     }
   limit=MaxBar;
  }

//----+     
for(bar=limit;bar>=0;bar--)
  {
  //----+    
  Temp_Series=iMAOnArray(Series_buffer,0,MA_period,0,MA_method, bar);
  //----+   Moving Avereges
  //----+    JJMASeries   0.  nJJMA.Length  nJJMA.Phase  t    (nJJMA.din=0)
  Resalt=JJMASeries(0,0,MaxBar,limit,Smooth_Phase,Smooth,Temp_Series,bar,reset);
  //----+       
  if(reset!=0)return(-1); 
  //----+    Resalt
  Resalt/=Norma;
  Resalt=NormalizeDouble(Resalt,0);
  Resalt*=Norma;
  //----+ 
  JMovingBuffer[bar]=Resalt; 
  //----+  
  UpperBuffer[bar]=Resalt+Half_Width;     
  LowerBuffer[bar]=Resalt-Half_Width;
  //----          
  
  }
//----    
return(0); 
} 

//+-------------------------------------------------------------------------+

